<?php
header('Content-Type: application/json');
include "../config.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Pokea data kutoka POST
    $user_id   = isset($_POST['user_id']) ? $_POST['user_id'] : '';
    $event_id  = isset($_POST['event_id']) ? $_POST['event_id'] : '';
    $full_name = isset($_POST['full_name']) ? $_POST['full_name'] : '';
    $chama     = isset($_POST['chama']) ? $_POST['chama'] : '';
    $nafasi    = isset($_POST['nafasi']) ? $_POST['nafasi'] : '';
    $gender    = isset($_POST['gender']) ? $_POST['gender'] : '';
    $region    = isset($_POST['region']) ? $_POST['region'] : '';
    $phone     = isset($_POST['phone']) ? $_POST['phone'] : '';

    // Hakikisha taarifa zote zimejazwa
    if (empty($user_id) || empty($event_id) || empty($full_name) || empty($chama) || empty($nafasi) || empty($gender) || empty($region) || empty($phone)) {
        error_log("Parameters missing: " . json_encode($_POST));
        echo json_encode([
            "success" => false,
            "message" => "Parameters missing."
        ]);
        exit;
    }

    // Sanitize data
    $user_id   = $conn->real_escape_string($user_id);
    $event_id  = $conn->real_escape_string($event_id);
    $full_name = $conn->real_escape_string($full_name);
    $chama     = $conn->real_escape_string($chama);
    $nafasi    = $conn->real_escape_string($nafasi);
    $gender    = $conn->real_escape_string($gender);
    $region    = $conn->real_escape_string($region);
    $phone     = $conn->real_escape_string($phone);

    // Angalia kama rekodi tayari ipo
    $checkSql = "SELECT id FROM event_members WHERE user_id = '$user_id' AND event_id = '$event_id'";
    $checkResult = $conn->query($checkSql);

    if ($checkResult && $checkResult->num_rows > 0) {
        error_log("User already exists: user_id=$user_id, event_id=$event_id");
        echo json_encode([
            "success" => false,
            "message" => "User already requested to join this event."
        ]);
        exit;
    }

    // Weka rekodi mpya na status default 0 (pending)
    $sql = "INSERT INTO event_members (event_id, user_id, full_name, chama, nafasi, gender, region, phone, status) 
            VALUES ('$event_id', '$user_id', '$full_name', '$chama', '$nafasi', '$gender', '$region', '$phone', 0)";

    if ($conn->query($sql)) {
        // Pata jina la event kutoka table ya events
        $eventQuery = "SELECT name FROM events WHERE id='$event_id'";
        $eventResult = $conn->query($eventQuery);
        $eventName = "";
        if ($eventResult && $eventResult->num_rows > 0) {
            $eventRow = $eventResult->fetch_assoc();
            $eventName = $eventRow['name'];
        }

        // Tengeneza ujumbe wa SMS
        $message = "Ndugu Admin,Kuna Ombi Jipya la Usajili, Tafadhali ingia Kuhakiki, Asante. Jisajili Kidigitali";
        error_log("SMS Message: " . $message);

        // Maelezo ya API ya Beem Africa
        $api_key = "5e04266e988e8256"; // Badilisha kama inahitajika
        $secret_key = "ZWZiZWM0ZTY0Y2IzNDU2MWI1YmE5NjkyOGZlOTMzNGU2ZWU3ZTkwNjgyYjg3MzkwYzljNjQ3OWRiZjhjZjdkNA=="; // Badilisha kama inahitajika
        $sender_name = "BlmSoft";

        // Orodha ya namba za simu zinazopokea SMS
        $sms_to = ["255768917743", "255717160105"]; // Ongeza namba zaidi ikiwa inahitajika

        // Andaa recipients array kwa namba zote
        $recipients = [];
        foreach ($sms_to as $index => $number) {
            $recipients[] = array('recipient_id' => $index + 1, 'dest_addr' => $number);
        }

        // Andaa payload ya SMS
        $postData = array(
            'source_addr'   => $sender_name,
            'encoding'      => 1,
            'schedule_time' => '',
            'message'       => $message,
            'recipients'    => $recipients
        );
        $postDataJson = json_encode($postData);

        // URL ya API ya Beem Africa
        $smsUrl = "https://apisms.beem.africa/v1/send";

        // Tumia cURL kutuma SMS
        $ch = curl_init($smsUrl);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt_array($ch, array(
            CURLOPT_POST           => TRUE,
            CURLOPT_RETURNTRANSFER => TRUE,
            CURLOPT_HTTPHEADER     => array(
                'Authorization: Basic ' . base64_encode("$api_key:$secret_key"),
                'Content-Type: application/json'
            ),
            CURLOPT_POSTFIELDS     => $postDataJson
        ));

        $smsResponse = curl_exec($ch);
        $curlError = curl_error($ch);
        curl_close($ch);

        if ($curlError) {
            error_log("cURL Error: " . $curlError);
        } else {
            error_log("SMS Response: " . $smsResponse);
        }

        echo json_encode([
            "success"     => true,
            "message"     => "Join request sent successfully. SMS sent.",
            "sms_response"=> $smsResponse,
            "curl_error"  => $curlError
        ]);
    } else {
        error_log("Database Insert Error: " . $conn->error);
        echo json_encode([
            "success" => false,
            "message" => "Error: " . $conn->error
        ]);
    }
} else {
    error_log("Invalid request method: " . $_SERVER['REQUEST_METHOD']);
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}

$conn->close();
?>
