<?php
header('Content-Type: application/json');
include "../config.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Pokea data kutoka POST
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : '';
    $event_id = isset($_POST['event_id']) ? $_POST['event_id'] : '';

    if (empty($user_id) || empty($event_id)) {
        echo json_encode([
            "success" => false,
            "message" => "Parameters missing."
        ]);
        exit;
    }

    // Hakikisha data salama
    $user_id = $conn->real_escape_string($user_id);
    $event_id = $conn->real_escape_string($event_id);

    // Chunguza kama rekodi ipo
    $sql = "SELECT status FROM event_members WHERE user_id = '$user_id' AND event_id = '$event_id' LIMIT 1";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $status = $row['status'];

        if ($status == 1) {
            echo json_encode([
                "success" => true,
                "joined"  => true,
                "status"  => 1,
                "message" => "Joined and approved"
            ]);
        } else if ($status == 0) {
            echo json_encode([
                "success" => true,
                "joined"  => true,
                "status"  => 0,
                "message" => "Join request pending approval"
            ]);
        } else if ($status == 2) {
            // 2 ina maana ombi limekataliwa
            echo json_encode([
                "success" => true,
                "joined"  => true,
                "status"  => 2,
                "message" => "Join request rejected"
            ]);
        }
    } else {
        // Hakuna rekodi, kwa hiyo user hajajoin
        echo json_encode([
            "success" => true,
            "joined"  => false,
            "message" => "User has not joined the event"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
}

$conn->close();
?>
