<?php
header('Content-Type: application/json');
include "../../config.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $event_id = isset($_POST['event_id']) ? $_POST['event_id'] : '';

    if (empty($event_id)) {
        echo json_encode([
            "success" => false,
            "message" => "Event ID is missing."
        ]);
        exit;
    }

    // Sanitize the event_id
    $event_id = $conn->real_escape_string($event_id);

    // Query: chukua ombi zote za tukio (pending approval) pamoja na taarifa za mtumiaji
    $sql = "SELECT em.event_id, em.user_id, em.status, u.first_name, u.last_name, u.adress 
            FROM event_members em 
            JOIN users u ON em.user_id = u.id 
            WHERE em.event_id = '$event_id' AND em.status = 0";

    $result = $conn->query($sql);

    if ($result) {
        $requests = [];
        while ($row = $result->fetch_assoc()) {
            $requests[] = $row;
        }
        echo json_encode([
            "success" => true,
            "requests" => $requests
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Query failed: " . $conn->error
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}

$conn->close();
?>
