<?php
header('Content-Type: application/json');
include '../../config.php';

// Pata event_id kutoka GET
$event_id = isset($_GET['event_id']) ? intval($_GET['event_id']) : 0;

// SQL query ili kuchukua data za event members walio approved (status '1') pamoja na details za user
$sql = "SELECT em.id, em.event_id, em.user_id, em.status, em.created_at, 
        u.first_name, u.last_name, u.phone, u.occupation, u.institution 
        FROM event_members em 
        JOIN users u ON em.user_id = u.id 
        WHERE em.event_id = ? AND em.status = '1'";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $event_id);
$stmt->execute();
$result = $stmt->get_result();

$members = array();
while ($row = $result->fetch_assoc()) {
    $members[] = $row;
}

$response = array(
    "success" => true,
    "members" => $members
);

echo json_encode($response);

$stmt->close();
$conn->close();
?>
