<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['id'])) {
        $speakerRecordId = $_POST['id'];

        // Prepare the delete query for the events_speakers table
        $query = "DELETE FROM events_speakers WHERE id = ?";
        $stmt = $conn->prepare($query);
        if ($stmt === false) {
            echo json_encode(['success' => false, 'message' => 'Database error: ' . $conn->error]);
            exit;
        }
        $stmt->bind_param("i", $speakerRecordId);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Speaker deleted successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to delete speaker']);
        }
        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Missing speaker record id']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
