<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if(isset($_POST['member_id']) && !empty($_POST['member_id'])){
        $member_id = $_POST['member_id'];

        // Andika query ya update kwa kubadilisha status kuwa 0
        $stmt = $conn->prepare("UPDATE event_members SET status = 0 WHERE id = ?");
        $stmt->bind_param("i", $member_id);

        if($stmt->execute()){
            $response = array("success" => true, "message" => "Member status updated to 0 successfully.");
        } else {
            $response = array("success" => false, "message" => "Failed to update member status.");
        }
        $stmt->close();
    } else {
        $response = array("success" => false, "message" => "Member id is required.");
    }
    $conn->close();
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    echo json_encode(array("success" => false, "message" => "Invalid request method."));
}
?>
