<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['id'])) {
        $agendaId = $_POST['id'];

        // Prepare the delete query
        $query = "DELETE FROM agenda WHERE id = ?";
        $stmt = $conn->prepare($query);
        if ($stmt === false) {
            echo json_encode(['success' => false, 'message' => 'Database error: ' . $conn->error]);
            exit;
        }
        $stmt->bind_param("i", $agendaId);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Agenda item deleted successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to delete agenda item']);
        }
        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Missing agenda id']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
