<?php
date_default_timezone_set("Africa/Dar_es_Salaam");
header('Content-Type: application/json');

include '../../config.php';

// Get POST variables
$event_id = $_POST['event_id'];

// Check if files are uploaded
if (isset($_FILES['images']) && count($_FILES['images']['name']) > 0) {
    $uploadDir = '../../uploads/gallery/';
    $uploadedFiles = [];

    // Loop through each uploaded image
    for ($i = 0; $i < count($_FILES['images']['name']); $i++) {
        $file = $_FILES['images'];

        $fileName = time() . '-' . basename($file['name'][$i]);
        $uploadPath = $uploadDir . $fileName;

        // Move the uploaded image to the server
        if (move_uploaded_file($file['tmp_name'][$i], $uploadPath)) {
            // Store file path in the database
            $stmt = $conn->prepare('INSERT INTO gallery (event_id, image) VALUES (?, ?)');
            $stmt->execute([$event_id, $uploadPath]);

            $uploadedFiles[] = $uploadPath;
        }
    }

    if (!empty($uploadedFiles)) {
        echo json_encode(['status' => 'success', 'message' => 'Images uploaded successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to upload images']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'No images uploaded']);
}
?>
