<?php
date_default_timezone_set("Africa/Dar_es_Salaam");
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $location = $_POST['location'];
    $start_date = date('Y-m-d H:i:s', strtotime($_POST['start_date']));
    $end_date = date('Y-m-d H:i:s', strtotime($_POST['end_date']));

    if (isset($_FILES['cover_image'])) {
        $image_name = time() . '_' . basename($_FILES['cover_image']['name']);
        $target_path = '../../uploads/events/' . $image_name;
        $full_image_path = '/uploads/events/' . $image_name; // Path in database
        
        if (move_uploaded_file($_FILES['cover_image']['tmp_name'], $target_path)) {
            $sql = "INSERT INTO events (name, cover_image, location, start_date, end_date) VALUES (?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('sssss', $name, $full_image_path, $location, $start_date, $end_date);
            
            if ($stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'Event added successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Database error']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Image upload failed']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'No image provided']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>
