<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $event_id = $_POST['event_id'];
    $user_id = $_POST['user_id'];
    $attendance_time = $_POST['attendance_time'];

    if (!empty($event_id) && !empty($user_id) && !empty($attendance_time)) {

        // Angalia kama member tayari ame-attend leo
        $checkQuery = "SELECT id FROM event_attendance WHERE user_id = ? AND event_id = ? AND DATE(attendance_time) = CURDATE()";
        $checkStmt = $conn->prepare($checkQuery);
        $checkStmt->bind_param("is", $user_id, $event_id);
        $checkStmt->execute();
        $checkStmt->store_result();

        if ($checkStmt->num_rows > 0) {
            $response = array(
                "success" => false, 
                "message" => "Member ameonekana tayari leo. Tafadhali subiri hadi kesho."
            );
            $checkStmt->close();
            $conn->close();
            header('Content-Type: application/json');
            echo json_encode($response);
            exit;
        }
        $checkStmt->close();

        // Insha rekodi mpya kwa attendance
        $stmt = $conn->prepare("INSERT INTO event_attendance (event_id, user_id, attendance_time) VALUES (?, ?, ?)");
        $stmt->bind_param("sis", $event_id, $user_id, $attendance_time);
        
        if ($stmt->execute()){
            $response = array("success" => true, "message" => "Attendance registered successfully.");
        } else {
            $response = array("success" => false, "message" => "Failed to register attendance.");
        }
        $stmt->close();
    } else {
        $response = array("success" => false, "message" => "Missing required parameters.");
    }
    $conn->close();
    header('Content-Type: application/json');
    echo json_encode($response);
} else {
    echo json_encode(array("success" => false, "message" => "Invalid request method."));
}
?>
