<?php
header('Content-Type: application/json');
include "../config.php";

// Define base URL
$base_url = "https://api.jisajilikidigitali.co.tz/";

// Check connection
if ($conn->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $conn->connect_error]));
}

$sql = "SELECT id, name, cover_image, location, start_date, end_date FROM events ORDER BY start_date DESC";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $events = [];
    while ($row = $result->fetch_assoc()) {
        $row['cover_image'] = $base_url . $row['cover_image'];
        $events[] = $row;
    }
    echo json_encode(["success" => true, "events" => $events]);
} else {
    echo json_encode(["success" => false, "message" => "No events found"]);
}

$conn->close();
?>
