<?php
header('Content-Type: application/json');
include "../config.php";

// Hakikisha parameter ya event_id imepelekwa
if (!isset($_GET['event_id'])) {
    echo json_encode([
        "success" => false,
        "message" => "Parameter ya event_id haipo."
    ]);
    exit();
}

$event_id = $conn->real_escape_string($_GET['event_id']);

// Chagua ujumbe wa chat pamoja na taarifa za sender
$sql = "SELECT c.id, c.user_id, c.event_id, c.message, c.time, 
               u.first_name, u.last_name, u.type 
        FROM chatsroom c
        JOIN users u ON c.user_id = u.id
        WHERE c.event_id = '$event_id' 
        ORDER BY c.time ASC";
$result = $conn->query($sql);

$chats = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $row['sender_name'] = $row['first_name'] . " " . $row['last_name'];
        $row['user_type'] = $row['type'] == 1 ? "Administrator" : "Member";
        unset($row['first_name'], $row['last_name'], $row['type']); // Ondoa extra fields
        $chats[] = $row;
    }
}

echo json_encode([
    "success" => true,
    "chats" => $chats
]);

$conn->close();
?>
