<?php
header('Content-Type: application/json');
include '../../config.php';

$event_id = isset($_GET['event_id']) ? intval($_GET['event_id']) : 0;
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';

if ($event_id <= 0) {
    echo json_encode(["success" => false, "message" => "Invalid event ID"]);
    exit;
}

// Pata jina la event
$eventQuery = "SELECT name FROM events WHERE id = ?";
$eventStmt = mysqli_prepare($conn, $eventQuery);
mysqli_stmt_bind_param($eventStmt, "i", $event_id);
mysqli_stmt_execute($eventStmt);
$eventResult = mysqli_stmt_get_result($eventStmt);
$event = mysqli_fetch_assoc($eventResult);
$event_name = $event ? $event['name'] : "Unknown Event";
mysqli_stmt_close($eventStmt);

// Chukua mahudhurio kwa kuunganisha na event_members kwa event_id na user_id
$query = "SELECT ea.id, ea.event_id, ea.user_id, ea.attendance_time, 
                 em.full_name, em.chama, em.nafasi, em.gender, em.region, em.phone 
          FROM event_attendance ea 
          JOIN event_members em ON ea.user_id = em.user_id AND ea.event_id = em.event_id 
          WHERE ea.event_id = ?";

if (!empty($start_date) && !empty($end_date)) {
    $query .= " AND DATE(ea.attendance_time) BETWEEN ? AND ?";
}

$stmt = mysqli_prepare($conn, $query);

if (!empty($start_date) && !empty($end_date)) {
    mysqli_stmt_bind_param($stmt, "iss", $event_id, $start_date, $end_date);
} else {
    mysqli_stmt_bind_param($stmt, "i", $event_id);
}

mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$attendance = [];
while ($row = mysqli_fetch_assoc($result)) {
    $row['event_name'] = $event_name; // Ongeza jina la event
    $attendance[] = $row;
}

mysqli_stmt_close($stmt);
mysqli_close($conn);

echo json_encode(["success" => true, "event_name" => $event_name, "attendance" => $attendance]);
?>
