<?php
include '../../config.php';

// Angalia kama POST parameters zote zimepangwa
if (
    isset($_POST['timetable_id']) &&
    isset($_POST['event_id']) &&
    isset($_POST['siku']) &&
    isset($_POST['date']) &&
    isset($_POST['start_time']) &&
    isset($_POST['end_time']) &&
    isset($_POST['tukio']) &&
    isset($_POST['mhusika'])
) {
    $timetable_id = $_POST['timetable_id'];
    $event_id     = $_POST['event_id'];
    $siku         = $_POST['siku'];
    $date         = $_POST['date'];
    $start_time   = $_POST['start_time'];
    $end_time     = $_POST['end_time'];
    $tukio       = $_POST['tukio'];
    $mhusika     = $_POST['mhusika'];
    
    // Andaa SQL statement kwa usalama (hapa inatumia prepared statement)
    $stmt = $conn->prepare("UPDATE timetable SET event_id = ?, siku = ?, date = ?, start_time = ?, end_time = ?, tukio = ?, mhusika = ? WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("issssssi", $event_id, $siku, $date, $start_time, $end_time, $tukio, $mhusika, $timetable_id);
        if ($stmt->execute()) {
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update timetable']);
        }
        $stmt->close();
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Prepared statement failed']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Missing parameters']);
}

mysqli_close($conn);
?>
