<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['id'])) {
        $timetableId = $_POST['id'];

        // Prepare the delete query for the timetable table
        $query = "DELETE FROM timetable WHERE id = ?";
        $stmt = $conn->prepare($query);
        if ($stmt === false) {
            echo json_encode(['success' => false, 'message' => 'Database error: ' . $conn->error]);
            exit;
        }
        $stmt->bind_param("i", $timetableId);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Timetable item deleted successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to delete timetable item']);
        }
        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Missing timetable id']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
