<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['id'])) {
        $documentId = $_POST['id'];

        // Prepare the delete query for the documents table
        $query = "DELETE FROM documents WHERE id = ?";
        $stmt = $conn->prepare($query);
        if ($stmt === false) {
            echo json_encode([
              'success' => false, 
              'message' => 'Database error: ' . $conn->error
            ]);
            exit;
        }
        $stmt->bind_param("i", $documentId);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Document deleted successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to delete document']);
        }
        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Missing document id']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
