<?php
include '../../config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['id'])) {
        $galleryId = $_POST['id'];

        // Prepare the delete query
        $query = "DELETE FROM gallery WHERE id = ?";
        $stmt = $conn->prepare($query);
        if ($stmt === false) {
            echo json_encode(['success' => false, 'message' => 'Database error: ' . $conn->error]);
            exit;
        }
        $stmt->bind_param("i", $galleryId);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Gallery item deleted successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to delete gallery item']);
        }
        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Missing gallery id']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
