<?php
header('Content-Type: application/json');
include "../../config.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $event_id = isset($_POST['event_id']) ? $_POST['event_id'] : '';
    $user_id  = isset($_POST['user_id']) ? $_POST['user_id'] : '';

    if (empty($event_id) || empty($user_id)) {
        echo json_encode([
            "success" => false,
            "message" => "Parameters missing."
        ]);
        exit;
    }

    // Sanitize data
    $event_id = $conn->real_escape_string($event_id);
    $user_id  = $conn->real_escape_string($user_id);

    // Update: set status = 1 kwa ombi husika
    $sql = "UPDATE event_members SET status = 1 WHERE event_id = '$event_id' AND user_id = '$user_id'";
    if ($conn->query($sql)) {

        // Chukua taarifa za mtumiaji kutoka table ya event_members
        $memberQuery = "SELECT full_name, phone FROM event_members WHERE event_id = '$event_id' AND user_id = '$user_id'";
        $memberResult = $conn->query($memberQuery);
        if ($memberResult && $memberResult->num_rows > 0) {
            $memberRow = $memberResult->fetch_assoc();
            $full_name = $memberRow['full_name'];
            $phone     = $memberRow['phone'];
            
            // Badilisha format ya namba ya simu ikiwa inaanza na 07 au 06
            if (substr($phone, 0, 2) === '07') {
                $phone = '2557' . substr($phone, 2);
            } else if (substr($phone, 0, 2) === '06') {
                $phone = '2556' . substr($phone, 2);
            }
            // Kama inaanza na "255", basi isigeuzi
        } else {
            echo json_encode([
                "success" => false,
                "message" => "User details not found."
            ]);
            exit;
        }

        // Chukua jina la event kutoka table ya events
        $eventQuery = "SELECT name FROM events WHERE id='$event_id'";
        $eventResult = $conn->query($eventQuery);
        if ($eventResult && $eventResult->num_rows > 0) {
            $eventRow = $eventResult->fetch_assoc();
            $eventName = $eventRow['name'];
        } else {
            $eventName = "";
        }

        // Tengeneza ujumbe wa SMS
        $smsMessage = "Ombi lako limekubaliwa,Ingia kwenye mfumo kuona Taarifa Zaidi.Asante";
        //$smsMessage = "Ndugu $full_name, ombi lako la kujiunga na event $eventName limekubaliwa. Asante.";
        //error_log("Approval SMS Message: " . $smsMessage);

        // Maelezo ya API ya Beem Africa
        $api_key    = "5e04266e988e8256"; // Badilisha kama inahitajika
        $secret_key = "ZWZiZWM0ZTY0Y2IzNDU2MWI1YmE5NjkyOGZlOTMzNGU2ZWU3ZTkwNjgyYjg3MzkwYzljNjQ3OWRiZjhjZjdkNA=="; // Badilisha kama inahitajika
        $sender_addr = "BlmSoft";

        // Andaa payload ya SMS kulingana na mfano uliotolewa
        $postData = array(
            'source_addr'   => $sender_addr,
            'encoding'      => 0,
            'schedule_time' => '',
            'message'       => $smsMessage,
            'recipients'    => array(
                array('recipient_id' => '1', 'dest_addr' => $phone)
            )
        );
        $postDataJson = json_encode($postData);
        error_log("Approval SMS Payload: " . $postDataJson);

        // URL ya API ya Beem Africa
        $smsUrl = "https://apisms.beem.africa/v1/send";

        // Tumia cURL kutuma SMS
        $ch = curl_init($smsUrl);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt_array($ch, array(
            CURLOPT_POST           => TRUE,
            CURLOPT_RETURNTRANSFER => TRUE,
            CURLOPT_HTTPHEADER     => array(
                'Authorization: Basic ' . base64_encode("$api_key:$secret_key"),
                'Content-Type: application/json'
            ),
            CURLOPT_POSTFIELDS     => $postDataJson
        ));

        $smsResponse = curl_exec($ch);
        $curlError   = curl_error($ch);
        curl_close($ch);

        if ($curlError) {
            error_log("Approval SMS cURL Error: " . $curlError);
        } else {
            error_log("Approval SMS Response: " . $smsResponse);
        }

        echo json_encode([
            "success"      => true,
            "message"      => "Request approved successfully.",
            "sms_response" => $smsResponse,
            "curl_error"   => $curlError
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Update failed: " . $conn->error
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method."
    ]);
}

$conn->close();
?>
