<?php
header('Content-Type: application/json');

include '../../config.php';

// Get POST variables
$event_id = $_POST['event_id'];
$description = $_POST['description'];

// Check if file is uploaded
if (isset($_FILES['document']) && $_FILES['document']['error'] == 0) {
    $file = $_FILES['document'];
    
    // Set upload directory
    $uploadDir = '../../uploads/documents/';
    $fileName = time() . '-' . basename($file['name']);
    $uploadPath = $uploadDir . $fileName;

    // Move file to uploads folder
    if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
        // Store file path in the database using $conn
        $query = 'INSERT INTO documents (event_id, file_path, description) VALUES (?, ?, ?)';
        $stmt = $conn->prepare($query);
        $stmt->bind_param('iss', $event_id, $uploadPath, $description);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Document uploaded successfully']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to store document information in database']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to upload document']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'No document uploaded']);
}
?>
